//
// refCurTest.java
//
import org.w3c.dom.*;
import oracle.xml.parser.v2.*;
import java.sql.*;
import oracle.jdbc.*;
import oracle.xml.sql.query.OracleXMLQuery;
import java.io.*;

public class refCurTest
{
  public static void main(String[] argv)
    throws SQLException
  { 
    String str;
    try
    {
      Connection conn  = getConnection("hr","hr"); // create connection

// Create a ResultSet object by calling the PL/SQL function
      CallableStatement stmt = 
        conn.prepareCall("begin ? := testRef.testRefCur(); end;");

      stmt.registerOutParameter(1,OracleTypes.CURSOR); // set the define type

      stmt.execute();   // Execute the statement.
      ResultSet rset = (ResultSet)stmt.getObject(1);  // Get the ResultSet

      OracleXMLQuery qry = new OracleXMLQuery(conn,rset); // prepare Query class
      qry.setRaiseNoRowsException(true);
      qry.setRaiseException(true);
      qry.keepObjectOpen(true);        // set options (keep the cursor active)
      while ((str = qry.getXMLString())!= null)
             System.out.println(str);

      qry.close();    // close the query

// Note since we supplied the statement and resultset, closing the
// OracleXMLquery instance will not close these. We need to 
// explicitly close this ourselves.
      stmt.close();
      conn.close();
    }
    catch (Exception e) {}
  } // end main

// Get the connection given the user name and password
  private static Connection getConnection(String user, String passwd)
    throws SQLException
  {
    DriverManager.registerDriver(new oracle.jdbc.OracleDriver());
    Connection conn =
      DriverManager.getConnection("jdbc:oracle:oci:@",user,passwd);
    return conn;
  } // end getConnection
} // end refCurTest
